import { RightOutlined } from "@ant-design/icons";
import { Col, Row, Space, Image } from "antd";
import { useRouter } from "next/router";
import { useEffect, useState } from "react";
import errImg from "~/assets/errImg";
import Layout from "~/components/layout";
import newsApi, { Item } from "../components/news/api";
import api, { DetailsResp } from "./api";
import styles from "./index.module.scss";

export default function CaseArticle() {
  const router = useRouter();
  const [data, setData] = useState<DetailsResp | null>(null);
  const [newsList, setNewList] = useState<Item[]>([]);

  //获取案例详情
  useEffect(() => {
    const id = Number(router.query.id);
    if (id) {
      api
        .details({
          id,
        })
        .then((res) => {
          setData(res.result || null);
        });
    }
  }, [router]);

  //获取新闻列表
  useEffect(() => {
    newsApi
      .listNewsPage({
        pageNo: 1,
        pageSize: 5,
      })
      .then((res) => {
        setNewList(res.result?.list || []);
      });
  });

  return (
    <Layout layoutStyle={{ backgroundColor: "#fff" }}>
      <div style={{ paddingTop: 29 }}>
        <Row justify="space-between">
          <Col flex="auto">
            <div className={styles.font1}>{data?.newsTitle}</div>
            <div
              className={styles.font2}
              style={{ marginTop: 18, marginBottom: 41 }}
            >
              {data?.createTime} · {data?.newsAuthor}
            </div>
            <div
              dangerouslySetInnerHTML={{ __html: data?.newsContents || "" }}
            ></div>
          </Col>
          <Col>
            <div className={styles.newsBox}>
              <Row
                className={styles.font4}
                align="middle"
                style={{ paddingTop: 24, paddingLeft: 24 }}
              >
                行业新闻
                <RightOutlined style={{ fontSize: 16, marginLeft: 15 }} />
              </Row>
              <Row gutter={10} style={{ marginTop: 18 }}>
                <Col span={24}>
                  {newsList.map((item) => {
                    return (
                      <Row
                        key={item.id}
                        justify="space-between"
                        align="middle"
                        style={{ cursor: "pointer" }}
                        onClick={() => {
                          router.push("/projectInfo/newsArticle/" + item.id);
                        }}
                      >
                        <Col
                          className={`${styles.font3} ${styles.ellipse2}`}
                          style={{ width: 217, padding: "13px 0 17px 20px" }}
                        >
                          {item.newsTitle}
                        </Col>
                        <Col style={{ paddingRight: 16 }}>
                          <Image
                            src={item.surfaceImg}
                            width={90}
                            height={60}
                            preview={false}
                            fallback={errImg}
                            style={{ borderRadius: 6 }}
                          ></Image>
                        </Col>
                      </Row>
                    );
                  })}
                </Col>
              </Row>
            </div>
          </Col>
        </Row>
      </div>
    </Layout>
  );
}
